% Document class for NUMELEC conference abstracts
% Author: N. Galopin - Univ. Grenoble Alpes
% Date: 10-27-2025
% Version: V1.0
%------------------------------------------------

\NeedsTeXFormat{LaTeX2e}

\ProvidesClass{NUMELEC}[2025/10/19 Class for NUMELEC abstract, V1.0]

% Base class
%-----------
\LoadClass[twocolumn,a4paper,10pt]{article}

% Extensions
%-----------
\RequirePackage[utf8]{inputenc}
\RequirePackage[TS1,T1]{fontenc}
\RequirePackage[english,french]{babel}
\RequirePackage{times}
\RequirePackage{graphicx}
\usepackage{abstract}
\RequirePackage[a4paper,inner=2.25cm,outer=1.75cm,top=1.65cm,bottom=2.1cm,headsep=0.25cm,footskip=0.8cm]{geometry}
\RequirePackage{titlesec}
\RequirePackage{fancyhdr}
\RequirePackage{enumitem}
\RequirePackage{caption}
\RequirePackage{booktabs}

% New commands
%-------------
\renewcommand{\absnamepos}{flushleft}
\setlength{\absleftindent}{0pt}
\setlength{\absrightindent}{0pt}

\providecommand{\keywords}[1]{\quotation\small\noindent{\bfseries{Keywords\ --}} #1 \bigskip}

% Title/Author(s)/Institution(s)/Abstract configuration
%------------------------------------------------------
\makeatletter
	\renewcommand{\maketitle}{\bgroup\setlength{\parindent}{0pt}
	\begin{flushleft}
  		\textbf{\large\@title}\\[8pt]
  		
  		\@author
	\end{flushleft}\egroup

	\renewenvironment{abstract}{%
  		\quotation
    	\small\noindent{\bfseries Abstract\ --}
    	\@endparpenalty\@M
	}
    {\if@twocolumn\par\medskip\else\endquotation\fi}
}
\makeatother

% New environment
%----------------
\newenvironment{References}{
	\vspace*{1em}
	\parindent=0mm
	\small \textbf{References} \footnotesize
	\begin{enumerate}[label=\footnotesize\bf{[\arabic*]}, font=\footnotesize]
}{
  \end{enumerate}
}

% Figure and table captions
%--------------------------
\captionsetup{margin=10pt,font=footnotesize}

% Configuring sections, subsections, and sub-subsections
%-------------------------------------------------------
\titleformat{\section}
	% format, label, sep, before
	{\fontsize{11}{13.2}\bfseries}
	{\Roman{section}}
	{0.75em}
	{}
\titlespacing{\section}
    % left, above, below
    {0pt}{9pt}{3pt}

\titleformat{\subsection}
    {\fontsize{10}{12}}
    {\Roman{section}.\alph{subsection}}
    {0.5em}
    {}
\titlespacing{\subsection}
    {0pt}{6pt}{2pt}

\titleformat{\subsubsection}
    {\fontsize{10}{12}}
    {}
    {0.5em}
    {}
\titlespacing{\subsubsection}
    {0pt}{3pt}{1pt}
    
% Header and footer
%------------------
\renewcommand{\headrulewidth}{0.3pt}
\renewcommand{\footrulewidth}{0.3pt}
\fancyfoot[L]{}
\fancyfoot[R]{}
\fancyhead[L]{11\up{ème} Conférence NUMELEC, 18-20 Novembre, 2026}
\fancyfoot[C]{}
\fancyhead[R]{}
\pagestyle{fancy}

% Thickness of lines and height of table rows
%--------------------------------------------
\setlength\heavyrulewidth{1.25pt}
\setlength\lightrulewidth{0.5pt}
